Scriptname _SLSubmitFunctions extends Quest  

import game
import debug

_SLSubmitConfig Property _SLConfig Auto
_SLSubmitQuest Property _SLQuest auto
_SLSubmitScene Property _SLScene Auto
SexLabFramework Property SexLab  Auto  
sslConfigMenu Property SexLabConfig  Auto  
Actor Property playerRef Auto

ReferenceAlias Property ActorAssailant1  Auto  
ReferenceAlias Property ActorAssailant2  Auto  
ReferenceAlias Property ActorFollower  Auto  
ReferenceAlias Property ActorBully  Auto  

GlobalVariable Property _SLSubmitSurrenderGlobal  Auto
GlobalVariable Property _SLSubmitBleedoutGlobal  Auto
Package Property BullyPackage Auto
SPELL Property _SLSubmitAssign  Auto  
Spell Property _SLSubmitBullyCloak Auto
SPELL Property _SLSubmitSurrender  Auto  
SPELL Property _SLSubmitRepeat5  Auto
SPELL Property _SLSubmitRepeat10  Auto
SPELL Property _SLSubmitRepeat15  Auto

Weapon Property MainHand  Auto  
Weapon Property OffHand  Auto  
Spell Property LSpell Auto
Spell Property RSpell Auto
Spell Property _SLSubmitUnarmed Auto
Armor Property Shield Auto
Armor Property Body Auto
Armor Property Boot Auto
Armor Property Glove Auto
Armor Property Helm Auto
Armor Property Necklace Auto
Armor Property Ring Auto

Weapon Property VictimWeapon1  Auto  
Weapon Property VictimWeapon2  Auto  
Weapon Property MainHand2  Auto  
Weapon Property OffHand2  Auto  
Spell Property LSpell2 Auto
Spell Property RSpell2 Auto
Armor Property Shield2 Auto

Int Property VampireStatus Auto Conditional
Message Property VampireFeedMessage Auto
Message Property VampireStageProgressionMessage Auto
Faction Property VampirePCFaction  Auto  
Float Property LastFeedTime Auto
Float Property FeedTimer Auto
GlobalVariable Property GameDaysPassed Auto
Idle Property _SLSubmitFeed Auto
Idle Property VampireFeedingBedRight Auto
Idle Property VampireFeedingBedrollRight Auto
GlobalVariable Property VampireFeedReady Auto
imageSpaceModifier Property VampireTransformIncreaseISMD  Auto
imageSpaceModifier Property VampireTransformDecreaseISMD  Auto 
effectShader property VampireChangeFX auto
FormList Property CrimeFactions  Auto  

GlobalVariable Property _SLSubmitSpeechBonus  Auto
Quest Property Alduin Auto
Quest Property Harbingers Auto
Quest Property College Auto
Quest Property Thieves Auto
Quest Property Brotherhood Auto
Perk Property Allure Auto
Perk Property HypnoticGaze Auto
Perk Property AspectOfTerror Auto
Perk Property Persuasion Auto
Perk Property Bribery Auto
Perk Property Intimidation Auto
Perk Property Dibella Auto
Perk Property Mara Auto
AssociationType Property Spouse  Auto  
AssociationType Property Courting  Auto  

FavorJarlsMakeFriendsScript Property FavorJarlsMakeFriends Auto
Faction Property _SLSubmitLoverFaction  Auto  
Faction Property _SLSubmitRejectedFaction Auto
Faction Property Companion Auto
Faction Property WinterholdTown  Auto
Faction Property FalkreathTown  Auto
Faction Property SolitudeTown  Auto
Faction Property MorthalTown  Auto
Faction Property DawnstarTown  Auto
Faction Property MarkathTown  Auto
Faction Property WhiterunTown  Auto
Faction Property RiftenTown  Auto
Faction Property CrimeEastmarch  Auto
Faction Property CrimeFalkreath  Auto
Faction Property CrimeHaafingar  Auto
Faction Property CrimeHjaalmarch  Auto
Faction Property CrimePale  Auto
Faction Property CrimeReach  Auto
Faction Property CrimeWhiterun  Auto
Faction Property CrimeWinterhold  Auto
Faction Property CrimeRift  Auto
Faction Property WindhelmTown  Auto
Faction Property SolitudePalace  Auto
Faction Property WindhelmPalace  Auto

Function UnArm(Actor Target)
	MainHand = Target.getEquippedWeapon()
	OffHand = Target.getEquippedWeapon(True)
	Shield = Target.getEquippedShield()
	LSpell = Target.getEquippedSpell(0)
	RSpell = Target.getEquippedSpell(1)
	_SLScene.WRT(0.1)
	If (MainHand != none)
		Target.UnEquipItem( MainHand, false, true)
	EndIf
	If (OffHand != none)
		_SLScene.WRT(0.1)
		Target.UnEquipItem( OffHand, false, true)
	EndIf
	If (Shield != none)
		Target.UnEquipItem( Shield, false, true)
	EndIf
	If (LSpell != none)
		Target.UnEquipSpell( LSpell, 0)
	EndIf
	If (RSpell != none)
		_SLScene.WRT(0.1)
		Target.UnEquipSpell( RSpell, 1)
	EndIf
EndFunction

Function UnArm2(Actor Target)
	MainHand2 = Target.getEquippedWeapon()
	OffHand2 = Target.getEquippedWeapon(True)
	Shield2 = Target.getEquippedShield()
	LSpell2 = Target.getEquippedSpell(0)
	RSpell2 = Target.getEquippedSpell(1)
	_SLScene.WRT(0.1)
	If (MainHand2 != none)
		Target.UnEquipItem( MainHand2, false, true)
	EndIf
	If (OffHand2 != none)
		_SLScene.WRT(0.1)
		Target.UnEquipItem( OffHand2, false, true)
	EndIf
	If (Shield2 != none)
		Target.UnEquipItem( Shield2, false, true)
	EndIf
	If (LSpell2 != none)
		Target.UnEquipSpell( LSpell2, 0)
	EndIf
	If (RSpell2 != none)
		_SLScene.WRT(0.1)
		Target.UnEquipSpell( RSpell2, 1)
	EndIf
EndFunction

Function ReArm(Actor Target)
	Target.AddSpell(_SLSubmitUnarmed, false)
	Target.EquipSpell( _SLSubmitUnarmed, 1)
	_SLScene.WRT(0.1)
	Target.UnEquipSpell( _SLSubmitUnarmed, 1)
	Target.RemoveSpell(_SLSubmitUnarmed)
	If (MainHand != none)
		Target.EquipItemEx( MainHand,1, false, true)
	EndIf
	If (Shield != none)
		Target.EquipItemEx( Shield, 0, false, true)
	EndIf
	If (OffHand != none)
		_SLScene.WRT(0.1)
		Target.EquipItemEx( OffHand,2, false, true)
	EndIf
	If (LSpell != none)
		Target.EquipSpell( LSpell, 0)
	EndIf
	If (RSpell != none)
		_SLScene.WRT(0.1)
		Target.EquipSpell( RSpell, 1)
	EndIf
EndFunction

Function ReArm2(Actor Target)
	Target.AddSpell(_SLSubmitUnarmed, false)
	Target.EquipSpell( _SLSubmitUnarmed, 1)
	_SLScene.WRT(0.1)
	Target.UnEquipSpell( _SLSubmitUnarmed, 1)
	Target.RemoveSpell(_SLSubmitUnarmed)
	If (MainHand2 != none)
		Target.EquipItemEx( MainHand2,1, false, true)
	EndIf
	If (Shield2 != none)
		Target.EquipItemEx( Shield2, 0, false, true)
	EndIf
	If (OffHand2 != none)
		_SLScene.WRT(0.1)
		Target.EquipItemEx( OffHand2,2, false, true)
	EndIf
	If (LSpell2 != none)
		Target.EquipSpell( LSpell2, 0)
	EndIf
	If (RSpell2 != none)
		_SLScene.WRT(0.1)
		Target.EquipSpell( RSpell2, 1)
	EndIf
EndFunction

Function SubmitFeed()
	;Effects for hiding the change
	;VampireChangeFX.play(PlayerRef)
	VampireTransformDecreaseISMD.applyCrossFade(2.0)
	_SLScene.WRT(2.0)
	imageSpaceModifier.removeCrossFade()
	;VampireChangeFX.stop(PlayerRef)
	
	Game.IncrementStat( "Necks Bitten" )
	VampireFeedMessage.Show()
	VampireFeedReady.SetValue(0)
	;Game.ForceThirdPerson()
	;PlayerRef.PlayIdle(VampireFeedingBedRight)
	;Player has fed, regress to Stage 1 Vampirisim
	;Remove Stage 2, 3, and 4 buffs and spells
	LastFeedTime =  GameDaysPassed.Value
	VampireStatus = 1
;	PVQ.VampireProgression(PlayerRef, 1)
	;Player is no longer hated
	PlayerRef.RemoveFromFaction(VampirePCFaction)
	PlayerRef.SetAttackActorOnSight(False)

	int cfIndex = 0
	while (cfIndex < CrimeFactions.GetSize())
; 		Debug.Trace("VAMPIRE: Removing enemy flag from " + CrimeFactions.GetAt(cfIndex))
		(CrimeFactions.GetAt(cfIndex) as Faction).SetPlayerEnemy(false)
		cfIndex += 1
	endwhile
	;Start checking GameTime again if we weren't already
	UnregisterforUpdateGameTime()
	RegisterForUpdateGameTime(12)
EndFunction

Function ClearAssailants()
	If (ActorAssailant1.GetActorRef() != None)
		ActorAssailant1.Clear()
	EndIf
	_SLScene.WRT(0.1)
	If (ActorAssailant2.GetActorRef() != None)
		ActorAssailant2.Clear()
	EndIf
	;ActorUtil.RemoveAllPackageOverride(BullyPackage)
	RemovePackageFromAllActors(BullyPackage)
EndFunction

Function RecheckAssailants()
	ClearAssailants()
	_SLSubmitSurrenderGlobal.SetValue(1)
	_SLSubmitAssign.Cast(PlayerRef)
	Surrender()
	_SLScene.WRT(2.0)
EndFunction

Function BleedOutStop()
	_SLSubmitBleedoutGlobal.SetValue(0)
	Debug.SendAnimationEvent(PlayerRef, "BleedOutStop")
	If (ActorFollower.GetActorRef() != None)
		Debug.SendAnimationEvent(ActorFollower.GetActorRef(), "BleedOutStop")
	EndIf
	_SLScene.WRT(2.5)
EndFunction

Function Surrender()
	_SLSubmitSurrender.Cast(PlayerRef)
EndFunction

Function RepeatRate()
	If (_SLConfig.RepeatRate == 5)
		_SLSubmitRepeat5.Cast(PlayerRef)
	ElseIf (_SLConfig.RepeatRate == 10)
		_SLSubmitRepeat10.Cast(PlayerRef)
	Else
		_SLSubmitRepeat15.Cast(PlayerRef)
	EndIf
EndFunction

Function CombatRecover()
	Debug.Notification("You are still in combat!")
	BleedOutStop()
	Game.EnablePlayerControls()
	If (ActorAssailant1.GetActorRef() != None)
		ActorAssailant1.Clear()
	EndIf
	_SLScene.WRT(0.1)
	If (ActorAssailant2.GetActorRef() != None)
		ActorAssailant2.Clear()
	EndIf
	If (ActorFollower.GetActorRef() != None)
		ActorFollower.Clear()
	EndIf
	If (ActorBully.GetActorRef() != None)
		ActorBully.Clear()
	EndIf
	_SLSubmitBullyCloak.Cast(PlayerRef)
	;ActorUtil.RemoveAllPackageOverride(BullyPackage)
	RemovePackageFromAllActors(BullyPackage)
EndFunction

Function SpeechModifier(Actor Target)
	_SLSubmitSpeechBonus.SetValue(Target.GetRelationshipRank(PlayerRef) * 10)
	If (Alduin.IsCompleted())
		_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 5)
	EndIf		
	If (Harbingers.IsCompleted())
		_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 5)
	EndIf	
	If (Thieves.IsCompleted())
		_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 5)
	EndIf	
	If (College.IsCompleted())
		_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 5)
	EndIf	
	If (Brotherhood.IsCompleted())
		_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 5)
	EndIf	
	If (PlayerRef.HasPerk(Allure))
		_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 5)
	EndIf	
	If (PlayerRef.HasPerk(Dibella))
		_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 5)
	EndIf	
	If (PlayerRef.HasPerk(Mara))
		_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 5)
	EndIf	
	If (Target.IsInFaction(_SLSubmitRejectedFaction))
		If(_SLConfig.debugActive)
			debug.Notification("Target already rejected you and will be difficult!")
		EndIf
	EndIf
	If (Target.IsGuard() && !Target.IsInFaction(Companion))
		If(_SLConfig.debugActive)
			debug.Notification("Target is an on duty Guard and will be very difficult!")
		EndIf
	EndIf	
	If (Target.HasAssociation(Spouse) && !Target.HasAssociation(Spouse, PlayerRef))
		If(_SLConfig.debugActive)
			debug.Notification("Target is already married and will be extremely difficult!")
		EndIf
	EndIf	
	If (Target.HasAssociation(Courting) && !Target.HasAssociation(Spouse, PlayerRef))
		If(_SLConfig.debugActive)
			debug.Notification("Target is already courting and will be difficult!")
		EndIf
	EndIf	
	If ((Target.GetLeveledActorBase().GetSex() == PlayerRef.GetActorBase().GetSex()) && (Target.GetRelationshipRank(PlayerRef) < 4) && (!Target.IsInFaction(_SLSubmitLoverFaction)))
		_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() - 10)
	EndIf	
	If ((Target.GetLeveledActorBase().GetRace() != PlayerRef.GetActorBase().GetRace()) && (Target.GetRelationshipRank(PlayerRef) < 4) && (!Target.IsInFaction(_SLSubmitLoverFaction)))
		_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() - 5)
	EndIf	
	If (FavorJarlsMakeFriends.WhiterunImpGetOutofJail > 0 || FavorJarlsMakeFriends.WhiterunSonsGetOutofJail > 0)
		If (Target.IsInFaction(WhiterunTown))
			_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 10)
		ElseIf (Target.IsInFaction(CrimeWhiterun))
			_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 5)
		EndIf
	EndIf
	If (FavorJarlsMakeFriends.EastmarchImpGetOutofJail > 0 || FavorJarlsMakeFriends.EastmarchSonsGetOutofJail > 0)
		If (Target.IsInFaction(WindhelmTown))
			_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 10)
		ElseIf (Target.IsInFaction(CrimeEastmarch) || Target.IsInFaction(WindhelmPalace))
			_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 5)
		EndIf
	EndIf
	If (FavorJarlsMakeFriends.FalkreathImpGetOutofJail > 0 || FavorJarlsMakeFriends.FalkreathSonsGetOutofJail > 0)
		If (Target.IsInFaction(FalkreathTown))
			_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 10)
		ElseIf (Target.IsInFaction(CrimeFalkreath))
			_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 5)
		EndIf
	EndIf
	If (FavorJarlsMakeFriends.HaafingarImpGetOutofJail > 0 || FavorJarlsMakeFriends.HaafingarSonsGetOutofJail > 0)
		If (Target.IsInFaction(SolitudeTown))
			_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 10)
		ElseIf (Target.IsInFaction(CrimeHaafingar) || Target.IsInFaction(SolitudePalace))
			_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 5)
		EndIf
	EndIf
	If (FavorJarlsMakeFriends.HjaalmarchImpGetOutofJail > 0 || FavorJarlsMakeFriends.HjaalmarchSonsGetOutofJail > 0)
		If (Target.IsInFaction(MorthalTown))
			_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 10)
		ElseIf (Target.IsInFaction(CrimeHjaalmarch))
			_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 5)
		EndIf
	EndIf
	If (FavorJarlsMakeFriends.PaleImpGetOutofJail > 0 || FavorJarlsMakeFriends.PaleSonsGetOutofJail > 0)
		If (Target.IsInFaction(DawnstarTown))
			_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 10)
		ElseIf (Target.IsInFaction(CrimePale))
			_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 5)
		EndIf
	EndIf
	If (FavorJarlsMakeFriends.ReachImpGetOutofJail > 0 || FavorJarlsMakeFriends.ReachSonsGetOutofJail > 0)
		If (Target.IsInFaction(MarkathTown))
			_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 10)
		ElseIf (Target.IsInFaction(CrimeReach))
			_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 5)
		EndIf
	EndIf
	If (FavorJarlsMakeFriends.WinterholdImpGetOutofJail > 0 || FavorJarlsMakeFriends.WinterholdSonsGetOutofJail > 0)
		If (Target.IsInFaction(WinterholdTown))
			_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 10)
		ElseIf (Target.IsInFaction(CrimeWinterhold))
			_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 5)
		EndIf
	EndIf
	If (FavorJarlsMakeFriends.RiftImpGetOutofJail > 0 || FavorJarlsMakeFriends.RiftSonsGetOutofJail > 0)
		If (Target.IsInFaction(RiftenTown))
			_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 10)
		ElseIf (Target.IsInFaction(CrimeRift))
			_SLSubmitSpeechBonus.SetValue(_SLSubmitSpeechBonus.GetValue() + 5)
		EndIf
	EndIf
EndFunction

; Removes Package thePackage from all actors who have it
Function RemovePackageFromAllActors(Package thePackage)

	int numberOfActors = StorageUtil.FormListCount(thePackage, "_SLSubmitBullyActorList")
	;debug.notification("Found " + numberOfActors  + " actors")
	int i = 0
	While (i < numberOfActors)
		Actor a = StorageUtil.FormListGet(thePackage,  "_SLSubmitBullyActorList" , i) as Actor
		If (a != None)
			;StorageUtil.FormListRemove(thePackage,"_SLSubmitBullyActorList" , a)
			ActorUtil.RemovePackageOverride(a, thePackage)
			;debug.notification("Removing from " + a.GetActorBase().GetName())
		EndIf
		i+=1
	EndWhile
	StorageUtil.FormListClear(thePackage,"_SLSubmitBullyActorList") 
EndFunction
